/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api;

import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationCreator;
import lib.toma.animations.api.lifecycle.IRegistryEntry;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public final class AnimationType<A extends IAnimation>
implements IRegistryEntry,
Comparable<AnimationType<?>> {
    private static int indexPool;
    private final int internalId = indexPool++;
    private final ResourceLocation name;
    private final IAnimationCreator<A> creator;
    private boolean renderSpecial;

    private AnimationType(ResourceLocation name, IAnimationCreator<A> creator) {
        this.name = name;
        this.creator = creator;
    }

    public static <A extends IAnimation> AnimationType<A> create(ResourceLocation uniqueID, IAnimationCreator<A> instanceCreator) {
        return new AnimationType<A>(uniqueID, instanceCreator);
    }

    public static <A extends IAnimation> AnimationType<A> create(ResourceLocation uniqueID) {
        return AnimationType.create(uniqueID, null);
    }

    public AnimationType<A> setSpecial() {
        this.renderSpecial = true;
        return this;
    }

    public boolean hasCreator() {
        return this.creator != null;
    }

    public boolean isSpecial() {
        return this.renderSpecial;
    }

    public A create(PlayerEntity client) {
        return this.creator.create(client);
    }

    @Override
    public ResourceLocation getKey() {
        return this.name;
    }

    public String toString() {
        return "AnimationType{name=" + this.name + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimationType that = (AnimationType)o;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(AnimationType<?> o) {
        return this.internalId - o.internalId;
    }
}

